//=============================================================================
// FlagTrigger.
//=============================================================================
class WeightTrigger extends Trigger;

var() bool bWhileStandingOnly;

function UnTouch(Actor Other)
{
	local Actor A;

	if ((bWhileStandingOnly) && (Other.IsA('Pawn')) || (Other.IsA('Containers')))
	{
	if (Event != '')
		foreach AllActors(class 'Actor', A, Event)
		{
			A.UnTrigger(Other, Instigator);
        		CheckCurTouches(A);
		}
	  Super.UnTouch(Other);
	}
}

function Touch(Actor Other)
{
	if ((Other.IsA('Pawn')) || (Other.IsA('Containers')))
        {
		Super.Touch(Other);
        }
}


function Trigger(Actor Other, Pawn Instigator)
{
	local Actor A;
				if (Event != '')
					foreach AllActors(class 'Actor', A, Event)
						A.Trigger(Other, Instigator);

				Super.Trigger(Other, Instigator);
}

function UnTrigger(Actor Other, Pawn Instigator)
{
	local Actor A;
		if (Event != '')
			foreach AllActors(class 'Actor', A, Event)
				A.Trigger(Other, Instigator);

				Super.UnTrigger(Other, Instigator);
}

function CheckCurTouches (Actor A)
{
  local Actor Target;

  ForEach VisibleActors(class'Actor',A,CollisionRadius,Location)
  {
    if ((A != None) && (A.IsA('Containers')))
    {
	if (Event != '')
		foreach AllActors(class 'Actor', Target, Event)
			Target.Trigger(A, Instigator);
    }
  }
}

defaultproperties
{
     bWhileStandingOnly=True;
     CollisionRadius=96.000000
}
